%
% techmech.cls
%
% latex document class article 
\LoadClass[twoside,10pt]{article}

% some packages and adjustment
\raggedbottom
\RequirePackage{multicol}
\RequirePackage{xcolor}
\RequirePackage{graphicx}
\definecolor{blue}{RGB}{0,102,255}
\RequirePackage{tabularx}
\RequirePackage[final]{microtype}
\RequirePackage{enumitem}
\RequirePackage{pict2e}
\RequirePackage[english]{babel}
\RequirePackage{placeins}
\flushbottom

\renewcommand{\baselinestretch}{1.00}

%
% page settings
\RequirePackage[a4paper,top=1.75cm, bottom=1.5cm, left=1.5cm, right=1.5cm]{geometry}
\setlength{\headsep}{5mm}
\setlength{\footskip}{5mm}
\setlength{\marginparwidth}{7mm}
\setlength{\headheight}{1.1\baselineskip}
\setlength{\parindent}{0mm}
\setlength{\topskip}{0mm}
%
% internal length settings
\RequirePackage{calc}
\setlength{\unitlength}{\textwidth*1/100} % \paperwidth divided by width definition of the picture 
\newcommand{\ul}{\unitlength}
%
% haeder and footer definitions
\RequirePackage{scrlayer-scrpage}
%\clearscrheadfoot
\clearpairofpagestyles
\pagestyle{scrheadings} 
\lehead{\upshape\sffamily\color{black!60}{\footnotesize \tmauthorlist}}
\lohead{\upshape\sffamily\color{black!60}{\footnotesize \tmauthorlist}}
\rehead{\upshape\sffamily\color{black!60}{\footnotesize Tech. Mech., \hvolume, \hissue, (\hyear), \hbpage--\hepage}}
\rohead{\upshape\sffamily\color{black!60}{\footnotesize Tech. Mech., \hvolume, \hissue, (\hyear), \hbpage--\hepage}}
\cfoot[{\thepage}]{\pagemark}

\defpagestyle{mystyle}{%
    (0pt, 0pt)
    {\headmark\hfill\pagemark}
    {\pagemark\hfill\headmark}
    {\pagemark\hfill\headmark}
    (\textwidth, 0.5pt)
}{%
    {\hfill}{\hfill}{\hfill}
}
\pagestyle{mystyle}
\lofoot[\upshape\color{black!60}\footnotesize \textsuperscript{$\star$}\,\textsf{E-mail address:} \href{mailto:\corremail}{\corremail}]{}
\lefoot[\upshape\color{black!60}\footnotesize \textsuperscript{$\star$}\,\textsf{E-mail address:} \href{mailto:\corremail}{\corremail}]{}
\cfoot[\upshape\color{black!60}\footnotesize\textsf{doi:}\,{\texttt{\href{https://dx.doi.org/\techmechdoi}{\rmfamily\techmechdoi}}}]{\pagemark}
\rofoot[\sffamily\color{black!60}\footnotesize \hyear\,$\vert$\,All rights reserved.]{}%\textcopyright
\refoot[\sffamily\color{black!60}\footnotesize \hyear\,$\vert$\,All rights reserved.]{}%\textcopyright

 
%  need natbib.sty
\RequirePackage[round]{natbib}
\bibstyle{kbib}
\newcommand*{\doi}[1]{doi: \href{http://dx.doi.org/#1}{\textcolor{blue}{#1}}}
\setlength{\bibsep}{2pt plus 2ex}
%
%
%
% mods of list environments
\setlist[itemize]{topsep=1ex,itemsep=0ex,partopsep=1ex,parsep=0.5ex}
\setlist[enumerate]{topsep=1ex,itemsep=0ex,partopsep=1ex,parsep=0.5ex}
%
\setlist[itemize,1]{label={\textcolor{black}{$\bullet$}}}
\setlist[itemize,2]{label={\textcolor{black}{$\circ$}}}
\setlist[itemize,3]{label={\textbf{\textcolor{black}{-}}}}
%
% mod of figure and table caption
\RequirePackage[format=hang,figurename=Fig.,tablename=Tab.]{caption} % figure captions, hanging second line
\captionsetup{skip=5pt}	% distance figure-caption
%
% article header variables
%
\newcommand{\hyear}{yyyy}
\newcommand{\hvolume}{Vol.\,x}
\newcommand{\hissue}{Is.\,x}
\newcommand{\hbpage}{bbb}
\newcommand{\hepage}{eee}
\newcommand{\hreceived}{dd.mm.yyyy}
\newcommand{\haccepted}{dd.mm.yyyy}
\newcommand{\honline}{dd.mm.yyyy}
\newcommand{\techmechdoi}{10.1000/999}
\newcommand{\corremail}{dr-doe@techmech-university.com}
%
% renew sectioning commands
%
% section

\renewcommand{\thesection}{\arabic{section}}
\renewcommand{\section}{\@startsection{section}
{1} % level
{0mm} % indent
{0.8\baselineskip} % beforeskip <0
{0.8\baselineskip} % afterskip >0
{\sffamily\large\textbf}}
% subsection
\renewcommand{\thesubsection}{\arabic{section}.\arabic{subsection}}
\renewcommand{\subsection}{\@startsection{subsection}
{2} % level
{0mm} % indent
{0.8\baselineskip} % beforeskip <0
{0.8\baselineskip} % afterskip >0
{\sffamily\normalsize\textbf}}
% subsubsection
\renewcommand{\thesubsubsection}{\arabic{section}.\arabic{subsection}.\arabic{subsubsection}}
\renewcommand{\subsubsection}{\@startsection{subsubsection}
{2} % level
{0mm} % indent
{0.8\baselineskip} % beforeskip <0
{0.8\baselineskip} % afterskip >0
{\sffamily\normalsize\textbf}}
%
% renew abstract environment
%
\newcommand\tmtitle{\title}
\newcommand{\tmabstract}{}
\newcommand{\tmkeywords}{}
\newcommand{\tmauthorlist}{}
%\newcommand{\tmhyperauthorlist}{\tmauthorlist}
%
%
%
\def\@maketitle{%
  \null
\thispagestyle{mystyle}
 \begin{picture}(100,11.5)
\put(0,0){\color{black!60}\line(1,0){100}}
\put(0,11.5){\color{black!60}\line(1,0){100}}
\put(0,10.75){\makebox(0,0)[lt]{\parbox{50\ul}{\raggedright\large\bfseries\sffamily\color{black!60}
TECHNISCHE MECHANIK
}}}
\put(0,6.5){\makebox(0,0)[lb]{\parbox{50\ul}{\raggedright\sffamily
\color{black!60}European Journal of Engineering Mechanics
}}}
\put(0,4.25){\makebox(0,0)[lb]{\parbox{50\ul}{\raggedright\sffamily
\color{black!60}Diamond Open Access
}}}
\put(0,0.5){\makebox(0,0)[lb]{\parbox{50\ul}{\raggedright\sffamily
\color{black!60}journal homepage: \href{http://www.ovgu.de/techmech}{\color{black!60}www.ovgu.de/techmech}
}}}
\put(100,10.8){\makebox(0,0)[rt]{\parbox{50\ul}{\raggedleft\sffamily\color{black!60}
 {\footnotesize Tech. Mech., \hvolume, \hissue, (\hyear), \hbpage--\hepage}\\
 \strut\\
  {\footnotesize Received: \hreceived}\\
  {\footnotesize Accepted: \haccepted}\\
  {\footnotesize Available online: \honline}
}}}
\end{picture} 
  \vskip 1.5em%
  {\raggedright
    {\Large\noindent\textbf{\sffamily\@title} \par}%
    \vskip 0.5em%
    {\normalsize\noindent{\@author} \par}%
    \vskip 1em%
   {\noindent\tiny\affil \par}}% end \raggeright
  \vskip 0.5em
  \textbf{\sffamily Abstract:}\,\rmfamily{\tmabstract}
  \vskip 0.5em
  \textbf{\sffamily Keywords:}\,\rmfamily\tmkeywords
    \vskip 1em
    \hrule
    \vskip 1.5em
  }
%
\newcommand{\tmappendix}{%
 \setcounter{equation}{0}
\renewcommand{\theequation}{A.\arabic{equation}}
\setcounter{figure}{0}
\renewcommand{\thefigure}{A.\arabic{figure}}
\setcounter{table}{0}
\renewcommand{\thetable}{A.\arabic{table}}
\setcounter{subsection}{0}
\renewcommand{\thesubsection}{A.\arabic{subsection}}
\setcounter{subsubsection}{0}
\renewcommand{\thesubsubsection}{A.\arabic{subsubsection}}
 }



\RequirePackage[fleqn]{mathtools}
% math and text font scheme: Times
\RequirePackage{newtxtext}
\RequirePackage[varvw]{newtxmath}
%\DeclareSymbolFont{CMletters}{OML}{cmm}{m}{it}
%\DeclareMathSymbol{\nu}{\mathord}{CMletters}{23}
%\DeclareMathSymbol{v}{\mathord}{CMletters}{`v}
% some math packages and math commands
%\RequirePackage{amssymb}
\newcommand{\tmbold}[1]{\mbox{\boldmath$#1$}} % only a help for smaller commands
\newcommand{\tena}[1]{\lowercase{\tmbold{#1}}} % tensors 1. order
\newcommand{\tenb}[1]{\uppercase{\tmbold{#1}}} % tensors 2. order
\newcommand{\tend}[1]{{\uppercase{\tmbold{\mathbb#1}}}} % tensors 4. Stufe
\DeclareMathAlphabet{\mathbfsf}{\encodingdefault}{\sfdefault}{bx}{n}
\newcommand{\vek}[1]{\lowercase{\mathbfsf#1}} % vectors
\newcommand{\mat}[1]{\uppercase{\mathbfsf#1}} % matrices
\newcommand{\dyad}{\otimes} % dyadic product
\newcommand{\skp}{\tmbold{\cdot\,}} % scalar product
\newcommand{\dskp}{\tmbold{:\,}} % double scalar product
\RequirePackage{calligra}
\newcommand{\tmcal}[1]{\text{\calligra{#1}\,}}



\NeedsTeXFormat{LaTeX2e}
%\ProvidesPackage{xxx}
\RequirePackage[pdfusetitle]{hyperref}
\makeatletter
\AtBeginDocument{\hypersetup{ pdfkeywords = {https://dx.doi.org/\techmechdoi},}}
\hypersetup{
  pdftitle    = {\@title},
  pdfsubject  = {Article in Journal Technische Mechanik - www.ovgu.de/techmech},
  pdfauthor   = {{\textcopyright} the authors},
  pdfcreator ={LaTeX with TechMech article class},
  pdfproducer = {},
  colorlinks=true,
  linkcolor=blue,
  citecolor=blue,
  linkcolor=blue,
  urlcolor=blue,
  breaklinks=true,
  pdfpagelayout=SinglePage,
}
\urlstyle{same}
%}
\makeatother
\RequirePackage{authblk}